//
//  LanguageListController.m
//  Presidents
//
//  Created by Robert Górczyński on 11-07-11.
//

#import "LanguageListController.h"

#import "DetailViewController.h" 

@implementation LanguageListController

@synthesize languageNames; 
@synthesize languageCodes; 
@synthesize detailViewController;

#pragma mark -
#pragma mark Cykl życiowy widoku


- (void)viewDidLoad {
    [super viewDidLoad];

	self.languageNames = [NSArray arrayWithObjects:@"angielski", @"francuski", 
						  @"hiszpański", @"niemiecki", @"polski", nil]; 
    self.languageCodes = [NSArray arrayWithObjects:@"en", @"fr", @"es",
						  @"de", @"pl", nil]; 
    self.clearsSelectionOnViewWillAppear = NO; 
    self.contentSizeForViewInPopover = CGSizeMake(320.0,  
												  [self.languageCodes count] * 44.0); 	
}

- (BOOL)shouldAutorotateToInterfaceOrientation:(UIInterfaceOrientation)interfaceOrientation {
    // Metodę można nadpisać w celu użycia układu innego niż domyślny pionowy.
    return YES;
}


#pragma mark -
#pragma mark Metody źródła danych TableView

- (NSInteger)numberOfSectionsInTableView:(UITableView *)tableView {
    // Zwrot liczby sekcji.
    return 1;
}


- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section {
    // Zwrot liczby rekordów w sekcji.
    return [self.languageCodes count];
}


// Dostosowanie do własnych potrzeb widoku komórki tabeli.
- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath {
    
    static NSString *CellIdentifier = @"Cell";
    
    UITableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:CellIdentifier];
    if (cell == nil) {
        cell = [[[UITableViewCell alloc] initWithStyle:UITableViewCellStyleDefault reuseIdentifier:CellIdentifier] autorelease];
    }
    
    // Konfiguracja komórki...
    cell.textLabel.text = [languageNames objectAtIndex:[indexPath row]]; 
    return cell;
}

#pragma mark -
#pragma mark Metody delegata TableView

- (void)tableView:(UITableView *)tableView didSelectRowAtIndexPath:(NSIndexPath *)indexPath {
	detailViewController.languageString = [self.languageCodes objectAtIndex: 
										   [indexPath row]]; 
}


#pragma mark -
#pragma mark Zarządzanie pamięcią

- (void)didReceiveMemoryWarning {
    // Jeżeli widok nie posiada widoku nadrzędnego, wówczas zostanie usunięty z pamięci.
    [super didReceiveMemoryWarning];
    
    // Usunięcie z pamięci wszelkich buforowanych danych, obrazów i innych zasobów, które obecnie nie są używane.
}

- (void)viewDidUnload {
    // Usunięcie wszystkiego, co może być ponownie utworzone w metodzie viewDidLoad lub na żądanie,
    // na przykład: self.myOutlet = nil;
    self.detailViewController = nil; 
    self.languageNames = nil; 
    self.languageCodes = nil; 	
}


- (void)dealloc {
    [detailViewController release]; 
    [languageNames release]; 
    [languageCodes release]; 	
    [super dealloc];
}


@end

